
##############################
# Country definition for SOV #
##############################

province =
{ id         = 133
  anti_air   = 2
  naval_base = { size = 7 current_size = 7 }
  air_base   = { size = 4 current_size = 4 }
}              # Murmansk
province =
{ id         = 154
  anti_air   = 4
  naval_base = { size = 3 current_size = 3 }
  air_base   = { size = 4 current_size = 4 }
}              # Archangelsk
province =
{ id          = 163
  air_base    = { size = 4 current_size = 4 }
  landfort    = 5
  coastalfort = 0
  anti_air    = 3
}               # Stalingrad
province =
{ id          = 175
  air_base    = { size = 10 current_size = 10 }
  landfort    = 5
  coastalfort = 0
  anti_air    = 4
}               # Moscow
province =
{ id       = 181
  air_base = { size = 3 current_size = 3 }
  anti_air = 1
}            # Kaluga
province =
{ id          = 187
  ic          = 7
  anti_air    = 6
  naval_base  = { size = 10 current_size = 10 }
  air_base    = { size = 10 current_size = 10 }
  landfort    = 5
  coastalfort = 5
}               # Leningrad
province = { id = 191 anti_air = 1 } # Porkhov
province =
{ id       = 201
  air_base = { size = 6 current_size = 6 }
}            # Opochka
province =
{ id       = 217
  air_base = { size = 2 current_size = 2 }
  anti_air = 2
}            # Vitebsk
province = { id = 219 anti_air = 3 } # Smolensk
province =
{ id       = 220
  air_base = { size = 8 current_size = 8 }
}            # Mogilev
province =
{ id         = 233
  anti_air   = 5
  naval_base = { size = 10 current_size = 10 }
  air_base   = { size = 10 current_size = 10 }
}              # Odessa
province =
{ id       = 238
  ic       = 8
  air_base = { size = 8 current_size = 8 }
}            # Kiev
province = { id = 246 anti_air = 2 } # Zaporozhye
province =
{ id       = 248
  air_base = { size = 6 current_size = 6 }
}            # Kharkov
province =
{ id          = 253
  anti_air    = 6
  naval_base  = { size = 10 current_size = 10 }
  air_base    = { size = 6 current_size = 6 }
  landfort    = 3
  coastalfort = 5
}               # Sevastopol
province =
{ id       = 258
  air_base = { size = 4 current_size = 4 }
}            # Rostov
province = { id = 263 anti_air = 1 } # Svoboda
province =
{ id       = 264
  air_base = { size = 2 current_size = 2 }
}            # Pavlovsk
province =
{ id       = 273
  air_base = { size = 2 current_size = 2 }
}            # Gomel
province = { id = 277 anti_air = 2 } # Bryansk
province =
{ id       = 282
  air_base = { size = 5 current_size = 5 }
}            # Orel
province =
{ id       = 289
  air_base = { size = 2 current_size = 2 }
}            # Demyansk
province =
{ id       = 1163
  air_base = { size = 1 current_size = 1 }
}            # Yakutsk
province =
{ id         = 1175
  anti_air   = 2
  naval_base = { size = 3 current_size = 3 }
}              # Ocha
province =
{ id       = 1368
  air_base = { size = 1 current_size = 1 }
}            # Komsomolsk-na-Amure
province =
{ id          = 1372
  anti_air    = 5
  naval_base  = { size = 10 current_size = 10 }
  air_base    = { size = 10 current_size = 10 }
  landfort    = 1
  coastalfort = 3
}               # Vladivostok
province =
{ id       = 1416
  air_base = { size = 3 current_size = 3 }
}            # Irkutsk
province = { id = 1422 ic = 8 } # Alma-Ata
province = { id = 1427 ic = 4 } # Tashkent
province = { id = 1429 ic = 6 } # Frunze
province = { id = 1485 ic = 4 } # Stalinabad
province = { id = 1490 ic = 4 } # Ashgabat
province =
{ id       = 1523
  air_base = { size = 2 current_size = 2 }
}            # Tynda
province =
{ id         = 1525
  anti_air   = 2
  naval_base = { size = 1 current_size = 1 }
  air_base   = { size = 1 current_size = 1 }
}              # Okhotsk
province =
{ id       = 1538
  air_base = { size = 1 current_size = 1 }
}            # Severo-Yenisejsk
province =
{ id       = 1544
  air_base = { size = 2 current_size = 2 }
}            # Tomsk
province = { id = 1548 ic = 8 } # Novosibirsk
province =
{ id       = 1550
  air_base = { size = 2 current_size = 2 }
}            # Semipalatinsk
province =
{ id       = 1552
  ic       = 2
  air_base = { size = 1 current_size = 1 }
}            # Omsk
province = { id = 1567 ic = 3 } # Ufa
province = { id = 1570 ic = 3 } # Chkalov
province = { id = 1572 ic = 4 } # Sverdlovsk
province =
{ id       = 1574
  ic       = 3
  air_base = { size = 1 current_size = 1 }
}            # Chelyabinsk
province =
{ id       = 1827
  air_base = { size = 2 current_size = 2 }
}            # Naberezhnye Chelny
province =
{ id       = 1828
  air_base = { size = 4 current_size = 4 }
}            # Kuybyshev
province =
{ id       = 1832
  air_base = { size = 3 current_size = 3 }
}            # Saratov
province =
{ id       = 1838
  anti_air = 2
  air_base = { size = 4 current_size = 4 }
}            # Astrakhan
province =
{ id       = 1839
  air_base = { size = 2 current_size = 2 }
}            # Novouzensk
province =
{ id         = 1848
  anti_air   = 2
  naval_base = { size = 3 current_size = 3 }
  air_base   = { size = 4 current_size = 4 }
}              # Batum
province = { id = 1850 ic = 8 } # Tblisi
province = { id = 1856 ic = 5 } # Yerevan

#####################
# Country main data #
#####################

country =
{ tag                    = SOV
  regular_id             = RUS
  intrinsic_gov_type     = leninist
  capital                = 175
  belligerence           = 5
  ground_def_eff         = 0.400
  # Resource Reserves
  energy                 = 1000
  metal                  = 1000
  rare_materials         = 500
  oil                    = 500
  supplies               = 500
  money                  = 100
  transports             = 10
  manpower               = 1600
  dissent                = 15
  policy =
  { date              = { year = 0 month = january day = 0 }
    democratic        = 1
    political_left    = 10
    freedom           = 1
    free_market       = 1
    professional_army = 1
    defense_lobby     = 6
    interventionism   = 4
  }
  SpyInfo                = { country = "SOV" NumberOfSpies = 8 }
  #SpyInfo                = { country = "ENG" NumberOfSpies = 5 }
  #SpyInfo                = { country = "FRA" NumberOfSpies = 4 }
  #SpyInfo                = { country = "GER" NumberOfSpies = 4 }
  #SpyInfo                = { country = "SLO" NumberOfSpies = 4 }
  #SpyInfo                = { country = "SPA" NumberOfSpies = 4 }
  #SpyInfo                = { country = "POL" NumberOfSpies = 8 }
  #SpyInfo                = { country = "SWE" NumberOfSpies = 5 }
  #SpyInfo                = { country = "NOR" NumberOfSpies = 4 }
  #SpyInfo                = { country = "FIN" NumberOfSpies = 8 }
  #SpyInfo                = { country = "YUG" NumberOfSpies = 8 }
  #SpyInfo                = { country = "HUN" NumberOfSpies = 5 }
  #SpyInfo                = { country = "BUL" NumberOfSpies = 8 }
  #SpyInfo                = { country = "BEL" NumberOfSpies = 4 }
  #SpyInfo                = { country = "DEN" NumberOfSpies = 4 }
  #SpyInfo                = { country = "CXB" NumberOfSpies = 5 }
  #SpyInfo                = { country = "MON" NumberOfSpies = 8 }
  #SpyInfo                = { country = "CGX" NumberOfSpies = 4 }
  #SpyInfo                = { country = "USA" NumberOfSpies = 8 }
  #SpyInfo                = { country = "GUA" NumberOfSpies = 4 }
  #SpyInfo                = { country = "GRE" NumberOfSpies = 4 }
  #SpyInfo                = { country = "CYN" NumberOfSpies = 8 }
  #SpyInfo                = { country = "CSX" NumberOfSpies = 4 }
  #SpyInfo                = { country = "JAP" NumberOfSpies = 10 }
  #SpyInfo                = { country = "ROM" NumberOfSpies = 5 }
  #SpyInfo                = { country = "LIT" NumberOfSpies = 5 }
  #SpyInfo                = { country = "LUX" NumberOfSpies = 4 }
  #SpyInfo                = { country = "POR" NumberOfSpies = 4 }
  #SpyInfo                = { country = "ITA" NumberOfSpies = 8 }
  #SpyInfo                = { country = "CHI" NumberOfSpies = 5 }
  #SpyInfo                = { country = "SCH" NumberOfSpies = 4 }
  #SpyInfo                = { country = "TUR" NumberOfSpies = 8 }
  nationalprovinces      = { 1372 1373 1371 1370 1369 1367 1366 1527 1529 1528 1526 1523 1410 1525 1524 1409 1164 1165 1166 1167 1170 1171 1172 1405
                             1174 1175 1176 1522 1521 1384 1383 1520 1416 1415 1414 1413 1162 1412 1411 1163 1159 1160 1158 1417 1558 1557 1423 1556
                             1550 1549 1547 1546 1559 1561 1560 1562 1563 1532 1537 1538 1545 1544 1548 1543 1540 1539 1536 1535 1533 1534 1157 1531
                             1156 1155 1154 1565 1564 1571 1597 1598 1554 1555 1553 1552 1594 1596 1573 1593 1592 1591 1590 1589 1588 1587 1424 1586
                             1585 1584 1583 1581 1576 1575 1574 1572 1566 1567 1570 1577 1578 1580 1582 1579 1569 1568 1150 1151 1152 1153 1773 1772
                             1771 154  1840 1841 165  153  151  152  150  135  134  133  1838 1847 1857 1849 1850 1848 1845 1844 1846 1843 255  256 
                             257  270  1842 1837 271  164  1833 1834 1836 1839 1827 1828 1835 1829 1832 1831 1830 252  253  254  1777 1778 1776 1775
                             1780 1781 1782 1783 1774 163  162  161  160  159  157  156  158  155  169  168  167  179  180  166  178  177  170  171 
                             172  173  174  175  176  181  182  183  184  190  191  189  185  186  187  188  192  200  201  212  225  226  227  228 
                             231  232  233  234  251  250  235  236  237  238  239  240  220  272  241  273  274  275  276  277  278  279  280  281 
                             282  283  284  249  258  259  260  248  247  243  262  261  269  268  267  266  265  264  263  1490 1491 1485 1487 1488
                             1427 1428 1426 1425 1429 94   1874 215  216  217  218  219  221  242  244  245  246  285  286  287  288  289  1149 1161
                             1368 1422 1489 1856 1858 1907 1541 1542 1551 199  195  194  196  193  197  198  202  203  204  205  577  511  206  207 
                             434  435  433  230  146  145  132 
                           }
  ownedprovinces         = { 1372 1373 1371 1370 1369 1367 1366 1527 1529 1528 1526 1523 1410 1525 1524 1409 1164 1165 1166 1167 1170 1171 1172 1405
                             1175 1522 1521 1384 1383 1520 1416 1415 1414 1413 1162 1412 1411 1163 1159 1160 1158 1417 1558 1557 1423 1556 1550 1549
                             1547 1546 1559 1561 1560 1562 1563 1532 1537 1538 1545 1544 1548 1543 1540 1539 1536 1535 1533 1534 1157 1531 1156 1155
                             1154 1565 1564 1571 1597 1598 1554 1555 1553 1552 1594 1596 1573 1593 1592 1591 1590 1589 1588 1587 1424 1586 1585 1584
                             1583 1581 1576 1575 1574 1572 1566 1567 1570 1577 1578 1580 1582 1579 1569 1568 1150 1151 1152 1153 1773 1772 1771 154 
                             1840 1841 165  153  151  152  150  135  134  133  1838 1847 1857 1849 1850 1848 1845 1844 1846 1843 255  256  257  270 
                             1842 1837 271  164  1833 1834 1836 1839 1827 1828 1835 1829 1832 1831 1830 252  253  254  1777 1778 1776 1775 1780 1781
                             1782 1783 1774 163  162  161  160  159  157  156  158  155  169  168  167  179  180  166  178  177  170  171  172  173 
                             174  175  176  181  182  183  184  190  191  189  185  186  187  188  192  200  201  212  225  226  227  228  231  232 
                             233  234  251  250  235  236  237  238  239  240  220  272  241  273  274  275  276  277  278  279  280  281  282  283 
                             284  249  258  259  260  248  247  243  262  261  269  268  267  266  265  264  263  1490 1491 1485 1487 1488 1427 1428
                             1426 1425 1429 94   1874 215  216  217  218  219  221  242  244  245  246  285  286  287  288  289  1149 1161 1368 1422
                             1489 1856 1858 1907 1541 1542 1551
                           }
  controlledprovinces    = { 1372 1373 1371 1370 1369 1367 1366 1527 1529 1528 1526 1523 1410 1525 1524 1409 1164 1165 1166 1167 1170 1171 1172 1405
                             1175 1522 1521 1384 1383 1520 1416 1415 1414 1413 1162 1412 1411 1163 1159 1160 1158 1417 1558 1557 1423 1556 1550 1549
                             1547 1546 1559 1561 1560 1562 1563 1532 1537 1538 1545 1544 1548 1543 1540 1539 1536 1535 1533 1534 1157 1531 1156 1155
                             1154 1565 1564 1571 1597 1598 1554 1555 1553 1552 1594 1596 1573 1593 1592 1591 1590 1589 1588 1587 1424 1586 1585 1584
                             1583 1581 1576 1575 1574 1572 1566 1567 1570 1577 1578 1580 1582 1579 1569 1568 1150 1151 1152 1153 1773 1772 1771 154 
                             1840 1841 165  153  151  152  150  135  134  133  1838 1847 1857 1849 1850 1848 1845 1844 1846 1843 255  256  257  270 
                             1842 1837 271  164  1833 1834 1836 1839 1827 1828 1835 1829 1832 1831 1830 252  253  254  1777 1778 1776 1775 1780 1781
                             1782 1783 1774 163  162  161  160  159  157  156  158  155  169  168  167  179  180  166  178  177  170  171  172  173 
                             174  175  176  181  182  183  184  190  191  189  185  186  187  188  192  200  201  212  225  226  227  228  231  232 
                             233  234  251  250  235  236  237  238  239  240  220  272  241  273  274  275  276  277  278  279  280  281  282  283 
                             284  249  258  259  260  248  247  243  262  261  269  268  267  266  265  264  263  1490 1491 1485 1487 1488 1427 1428
                             1426 1425 1429 94   1874 215  216  217  218  219  221  242  244  245  246  285  286  287  288  289  1149 1161 1368 1422
                             1489 1856 1858 1907 1541 1542 1551
                           }
  # Rocket Test and Research Facility		
  # Air Doctrines 1936
  # ################
  techapps               = { 5550 1310 4030 4060 1230 1210 1220 9010 9020 9030 9040 9090 4010 4020 4120 4130 4170 4250 4220 2010 2020 2030 2040 2150
                             2290 2300 2310 2320 2450 2050 2070 2100 2330 2400 2460 2510 5010 5020 5050 5080 5090 5100 5190 5200 5470 1010 1020 1110
                             1190 1030 1070 1200 6210 6300 6310 8010 8020 8030 8040 8050 8070 3010 3020 3030 3070 3080 3090 3130 3140 3190 3200 3250
                             3260 3270 3280 3400 3410 3420 3430
                           }
  diplomacy =
  { relation =
    { tag        = AFG
      value      = 1
      guaranteed = { day = 30 month = december year = 1938 }
    }
    relation = { tag = BRA value = -50 }
    relation =
    { tag        = BUL
      value      = 15
      guaranteed = { day = 30 month = december year = 1938 }
    }
    relation = { tag = SLO value = -100 }
    relation = { tag = ENG value = -25 }
    relation =
    { tag        = EST
      value      = -30
      guaranteed = { day = 30 month = december year = 1938 }
    }
    relation =
    { tag        = FIN
      value      = 1
      guaranteed = { day = 30 month = december year = 1938 }
    }
    relation = { tag = FRA value = 100 }
    relation = { tag = GER value = 20 }
    relation =
    { tag        = LAT
      value      = -30
      guaranteed = { day = 30 month = december year = 1938 }
    }
    relation =
    { tag        = LIT
      value      = -30
      guaranteed = { day = 30 month = december year = 1938 }
    }
    relation = { tag = MON value = 150 access = yes }
    relation = { tag = PER value = -20 }
    relation = { tag = POL value = -50 }
    relation =
    { tag        = ROM
      value      = 1
      guaranteed = { day = 30 month = december year = 1938 }
    }
    relation =
    { tag        = SIK
      value      = 125
      guaranteed = { day = 30 month = december year = 1938 }
    }
    relation = { tag = SPA value = -100 }
    relation =
    { tag        = TAN
      value      = 200
      guaranteed = { day = 30 month = december year = 1938 }
      access     = yes
    }
    relation =
    { tag        = TUR
      value      = 70
      guaranteed = { day = 30 month = december year = 1938 }
    }
    relation = { tag = URU value = -100 }
    relation = { tag = USA value = 35 }
  }
  headofstate            = { type = 9 id = 4001 }
  headofgovernment       = { type = 9 id = 4002 }
  foreignminister        = { type = 9 id = 4034 }
  armamentminister       = { type = 9 id = 4004 }
  ministerofsecurity     = { type = 9 id = 4041 }
  ministerofintelligence = { type = 9 id = 4046 }
  chiefofstaff           = { type = 9 id = 4051 }
  chiefofarmy            = { type = 9 id = 4008 }
  chiefofnavy            = { type = 9 id = 4062 }
  chiefofair             = { type = 9 id = 4064 }
  dormant_ministers      = { 4003 4005 4006 4007 4009 4010 }
  dormant_leaders        = { 9839  9841  9843  9849  9884  9894  9896  9900  9907  9910  9926  9930  9951  9955  9969  9974  9991  9993  10006 10016
                             10019 10028 10031 10042 10054 10066 10071 10114 10115 10137 10138 10202 10208 10215 10253 10271 10276 10283 10286 10297
                             10322 10342 10349 10369 10370 10371 10401 10417 10453 10463 10472 10477 10500 10514 10515 10516 10517 10518 10520 10521
                             10522
                           }
  landunit =
  { id       = { type = 30008 id = 1001 }
    name     = "ͳ˧ "
    location = 175
    division =
    { id       = { type = 30008 id = 1002 }
      name     = "ͳ˧ "
      strength = 100
      type     = hq
    }
  }
  landunit =
  { id       = { type = 30008 id = 1003 }
    name     = "շ "
    location = 187
    division =
    { id       = { type = 30008 id = 1004 }
      name     = "շ˾ "
      strength = 100
      type     = hq
    }
  }
  landunit =
  { id       = { type = 30008 id = 1005 }
    name     = " "
    location = 219
    division =
    { id       = { type = 30008 id = 1006 }
      name     = "˾ "
      strength = 100
      type     = hq
    }
  }
  landunit =
  { id       = { type = 30008 id = 1007 }
    name     = "Զһ "
    location = 1372
    division =
    { id       = { type = 30008 id = 1008 }
      name     = "Զһ˾ "
      strength = 100
      type     = hq
    }
  }
  landunit =
  { id       = { type = 30008 id = 1 }
    name     = "һеž "
    location = 187
    division =
    { id       = { type = 30008 id = 2 }
      name     = "3̹-163Ħлʦ "
      strength = 80
      type     = motorized
      extra    = anti_tank
    }
    division =
    { id       = { type = 30008 id = 3 }
      name     = "177ʦ "
      strength = 60
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 233 }
      name     = "191ʦ "
      strength = 60
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 234 }
      name     = "8'˹'ʦ "
      strength = 60
      type     = infantry
    }
  }
  # #####################
  # ######################
  landunit =
  { id       = { type = 30008 id = 4 }
    name     = "7ž "
    location = 152
    division =
    { id       = { type = 30008 id = 5 }
      name     = "54ʦ "
      strength = 80
      type     = infantry
      extra    = anti_air
    }
    division =
    { id       = { type = 30008 id = 235 }
      name     = "71ʦ "
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 6 }
      name     = "168ʦ "
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 236 }
      name     = "237ʦ "
      strength = 80
      type     = infantry
    }
  }
  # ############################
  # ############################
  landunit =
  { id       = { type = 30008 id = 7 }
    name     = "14ž "
    location = 191
    division =
    { id            = { type = 30008 id = 8 }
      name          = "122ʦ "
      strength      = 80
      type          = infantry
      extra         = artillery
      brigade_model = 2
    }
    division =
    { id       = { type = 30008 id = 237 }
      name     = "104ʦ "
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 9 }
      name     = "14'޸'ʦ "
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 238 }
      name     = "52ʦ "
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 10 }
      name     = "1̹ʦ "
      strength = 30
      type     = light_armor
      model    = 1
    }
  }
  # #########################
  # #########################
  landunit =
  { id       = { type = 30008 id = 11 }
    name     = "23ž "
    location = 216
    division =
    { id            = { type = 30008 id = 12 }
      name          = "142ʦ "
      strength      = 80
      type          = infantry
      extra         = artillery
      brigade_model = 2
    }
    division =
    { id       = { type = 30008 id = 239 }
      name     = "43ʦ "
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 13 }
      name     = "70ʦ "
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 240 }
      name     = "123ʦ "
      strength = 80
      type     = infantry
    }
    division =
    { id            = { type = 30008 id = 15 }
      name          = "198Ħл/115ʦ "
      strength      = 80
      type          = motorized
      extra         = artillery
      brigade_model = 2
    }
  }
  # ###########################
  # #############################
  landunit =
  { id       = { type = 30008 id = 16 }
    name     = "8ž "
    location = 219
    division =
    { id       = { type = 30008 id = 17 }
      name     = "10ʦ "
      strength = 80
      type     = infantry
    }
    division =
    { id            = { type = 30008 id = 241 }
      name          = "48ʦ "
      strength      = 80
      extra         = artillery
      brigade_model = 2
      type          = infantry
    }
    division =
    { id       = { type = 30008 id = 18 }
      name     = "90ʦ "
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 242 }
      name     = "125ʦ "
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 20 }
      name     = "202Ħл/11ʦ "
      strength = 80
      type     = motorized
      extra    = engineer
    }
  }
  # ##########################
  # ###########################
  landunit =
  { id       = { type = 30008 id = 21 }
    name     = "11ž "
    location = 220
    division =
    { id            = { type = 30008 id = 22 }
      name          = "5'άݲ˹'ʦ "
      strength      = 80
      type          = infantry
      extra         = artillery
      brigade_model = 2
    }
    division =
    { id       = { type = 30008 id = 243 }
      name     = "179ʦ "
      strength = 80
      type     = infantry
    }
    division =
    { id            = { type = 30008 id = 23 }
      name          = "184ʦ "
      strength      = 80
      type          = infantry
      extra         = artillery
      brigade_model = 2
    }
    division =
    { id       = { type = 30008 id = 244 }
      name     = "33'׶˹'ʦ "
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 24 }
      name     = "2/5̹ʦ "
      strength = 80
      type     = light_armor
      model    = 1
    }
    division =
    { id       = { type = 30008 id = 25 }
      name     = "84Ħл/188ʦ "
      strength = 80
      type     = motorized
      extra    = engineer
    }
    division =
    { id       = { type = 30008 id = 26 }
      name     = "126ʦ "
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 245 }
      name     = "128ʦ "
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 246 }
      name     = "23'Ʒ'ʦ "
      strength = 100
      type     = infantry
    }
  }
  # ######################
  # #######################
  landunit =
  { id       = { type = 30008 id = 27 }
    name     = "27ž "
    location = 272
    division =
    { id            = { type = 30008 id = 28 }
      name          = "180ʦ "
      strength      = 100
      type          = infantry
      extra         = artillery
      brigade_model = 2
    }
    division =
    { id       = { type = 30008 id = 247 }
      name     = "181ʦ "
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 248 }
      name     = "182ʦ "
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 29 }
      name     = "16'ŵ'ʦ "
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 249 }
      name     = "67ʦ "
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 250 }
      name     = "183ʦ "
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 30 }
      name     = "3'ٻ˶'ʦ "
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 251 }
      name     = "22'˹ŵ'ʦ "
      strength = 80
      type     = infantry
    }
  }
  # ##############################
  # ##############################
  landunit =
  { id       = { type = 30008 id = 31 }
    name     = "47ž "
    location = 240
    division =
    { id       = { type = 30008 id = 32 }
      name     = "143ʦ "
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 252 }
      name     = "121ʦ "
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 253 }
      name     = "55ʦ "
      strength = 100
      type     = infantry
    }
  }
  # ###########################
  # ###########################
  landunit =
  { id       = { type = 30008 id = 33 }
    name     = "ʮ߻еž "
    location = 175
    division =
    { id       = { type = 30008 id = 35 }
      name     = "209/210Ħлʦ "
      strength = 60
      type     = motorized
      extra    = anti_tank
    }
  }
  # ###############################
  # ##############################
  landunit =
  { id       = { type = 30008 id = 49 }
    name     = "3ž "
    location = 238
    division =
    { id            = { type = 30008 id = 50 }
      name          = "27'ľ˹'ʦ "
      strength      = 100
      type          = infantry
      extra         = artillery
      brigade_model = 2
    }
    division =
    { id       = { type = 30008 id = 254 }
      name     = "24'.ŵ'ʦ "
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 255 }
      name     = "17'Ʒ'ʦ "
      strength = 100
      type     = infantry
    }
    division =
    { id            = { type = 30008 id = 51 }
      name          = "50''ʦ "
      strength      = 100
      type          = infantry
      extra         = artillery
      brigade_model = 2
    }
    division =
    { id       = { type = 30008 id = 256 }
      name     = "56'Ī˹'ʦ "
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 257 }
      name     = "85ʦ "
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 53 }
      name     = "75ʦ "
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 258 }
      name     = "37ʦ "
      strength = 80
      type     = infantry
    }
  }
  # #########################
  # #########################
  landunit =
  { id       = { type = 30008 id = 54 }
    name     = "4ž "
    location = 237
    division =
    { id            = { type = 30008 id = 55 }
      name          = "6'¶˹'ʦ "
      strength      = 100
      type          = infantry
      extra         = artillery
      brigade_model = 2
    }
    division =
    { id       = { type = 30008 id = 259 }
      name     = "42ʦ "
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 260 }
      name     = "49ʦ "
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 57 }
      name     = "204/205Ħлʦ "
      strength = 80
      type     = motorized
      extra    = anti_tank
    }
  }
  # ########################
  # #########################
  landunit =
  { id       = { type = 30008 id = 58 }
    name     = "10ž "
    location = 236
    division =
    { id       = { type = 30008 id = 59 }
      name     = "86ʦ "
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 261 }
      name     = "13'Ｊ˹̹'ʦ "
      strength = 100
      type     = infantry
    }
    division =
    { id            = { type = 30008 id = 262 }
      name          = "2'׶˹'ʦ "
      strength      = 100
      type          = infantry
      extra         = artillery
      brigade_model = 2
    }
    division =
    { id            = { type = 30008 id = 60 }
      name          = "113ʦ "
      strength      = 80
      type          = infantry
      extra         = artillery
      brigade_model = 2
    }
    division =
    { id       = { type = 30008 id = 263 }
      name     = "8'˹'ʦ "
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 61 }
      name     = "6'٤'ʦ "
      strength = 80
      type     = cavalry
    }
    division =
    { id       = { type = 30008 id = 62 }
      name     = "4/7̹ʦ "
      strength = 80
      type     = armor
      model    = 1
    }
    division =
    { id       = { type = 30008 id = 64 }
      name     = "29/208ĿĦлʦ "
      strength = 80
      type     = motorized
      extra    = anti_tank
    }
  }
  # ##########################
  # ###########################
  landunit =
  { id       = { type = 30008 id = 65 }
    name     = "13ž "
    location = 234
    division =
    { id       = { type = 30008 id = 66 }
      name     = "161ʦ "
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 264 }
      name     = "100ʦ "
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 67 }
      name     = "64ʦ "
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 265 }
      name     = "108ʦ "
      strength = 80
      type     = infantry
    }
  }
  # ##########################
  # ##########################
  landunit =
  { id       = { type = 30008 id = 68 }
    name     = "31ž "
    location = 253
    division =
    { id       = { type = 30008 id = 69 }
      name     = "193ʦ "
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 266 }
      name     = "195ʦ "
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 267 }
      name     = "200ʦ "
      strength = 100
      type     = infantry
    }
  }
  # ##########################
  # ##########################
  landunit =
  { id       = { type = 30008 id = 70 }
    name     = "36ž "
    location = 1848
    division =
    { id       = { type = 30008 id = 71 }
      name     = "140ʦ "
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 268 }
      name     = "146ʦ "
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 269 }
      name     = "228ʦ "
      strength = 100
      type     = infantry
    }
  }
  # #########################
  # #########################
  landunit =
  { id       = { type = 30008 id = 72 }
    name     = "49ž "
    location = 1850
    division =
    { id       = { type = 30008 id = 73 }
      name     = "199ʦ "
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 270 }
      name     = "197''ʦ "
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 271 }
      name     = "190ʦ "
      strength = 100
      type     = infantry
    }
  }
  # #################################
  # #################################
  landunit =
  { id       = { type = 30008 id = 74 }
    name     = "55ž "
    location = 1857
    division =
    { id       = { type = 30008 id = 75 }
      name     = "189ʦ "
      strength = 70
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 272 }
      name     = "169ʦ "
      strength = 70
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 273 }
      name     = "130ʦ "
      strength = 70
      type     = infantry
    }
  }
  # #############################
  # #############################
  landunit =
  { id       = { type = 30008 id = 79 }
    name     = "ʮеž "
    location = 1490
    division =
    { id       = { type = 30008 id = 81 }
      name     = "131/212Ħлʦ "
      strength = 80
      type     = motorized
      extra    = anti_tank
    }
  }
  # ###############################
  # ###############################
  landunit =
  { id       = { type = 30008 id = 85 }
    name     = "ڶʮĻеž "
    location = 1520
    division =
    { id       = { type = 30008 id = 87 }
      name     = "213/216Ħлʦ "
      strength = 80
      type     = motorized
      extra    = anti_tank
    }
  }
  # ###############################
  # ###############################
  landunit =
  { id       = { type = 30008 id = 88 }
    name     = "5ž "
    location = 1368
    division =
    { id            = { type = 30008 id = 89 }
      name          = "45''ʦ "
      strength      = 80
      type          = infantry
      extra         = artillery
      brigade_model = 2
    }
    division =
    { id       = { type = 30008 id = 274 }
      name     = "87ʦ "
      strength = 80
      type     = infantry
    }
    division =
    { id            = { type = 30008 id = 90 }
      name          = "62'˹̹'ʦ "
      strength      = 80
      type          = infantry
      extra         = artillery
      brigade_model = 2
    }
    division =
    { id       = { type = 30008 id = 275 }
      name     = "124ʦ "
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 92 }
      name     = "135ʦ "
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 276 }
      name     = "97ʦ "
      strength = 80
      type     = infantry
    }
  }
  # ###############################
  # ##############################
  landunit =
  { id       = { type = 30008 id = 93 }
    name     = "6ž "
    location = 1371
    division =
    { id            = { type = 30008 id = 94 }
      name          = "41ʦ "
      strength      = 100
      type          = infantry
      extra         = artillery
      brigade_model = 2
    }
    division =
    { id       = { type = 30008 id = 277 }
      name     = "80ʦ "
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 278 }
      name     = "159ʦ "
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 95 }
      name     = "139ʦ "
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 279 }
      name     = "141ʦ "
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 96 }
      name     = "3''ʦ "
      strength = 80
      type     = cavalry
    }
    division =
    { id       = { type = 30008 id = 98 }
      name     = "215/81Ħлʦ "
      strength = 80
      type     = motorized
      extra    = anti_tank
    }
  }
  # ##############################
  # ##############################
  landunit =
  { id       = { type = 30008 id = 99 }
    name     = "12ž "
    location = 258
    division =
    { id            = { type = 30008 id = 100 }
      name          = "164ʦ "
      strength      = 100
      type          = infantry
      extra         = artillery
      brigade_model = 2
    }
    division =
    { id       = { type = 30008 id = 280 }
      name     = "58ʦ "
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 101 }
      name     = "60ʦ "
      strength = 80
      type     = bergsjaeger
    }
    division =
    { id       = { type = 30008 id = 281 }
      name     = "69ʦ "
      strength = 80
      type     = bergsjaeger
    }
    division =
    { id       = { type = 30008 id = 103 }
      name     = "192ʦ "
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 282 }
      name     = "44ʦ "
      strength = 80
      type     = infantry
    }
  }
  # ################################
  # ################################
  landunit =
  { id       = { type = 30008 id = 104 }
    name     = "26ž "
    location = 133
    division =
    { id       = { type = 30008 id = 105 }
      name     = "99ʦ "
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 283 }
      name     = "173ʦ "
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 107 }
      name     = "240/7Ħлʦ "
      strength = 60
      type     = motorized
      extra    = anti_tank
    }
  }
  # ###########################
  # ############################
  landunit =
  { id       = { type = 30008 id = 108 }
    name     = "7ž "
    location = 260
    division =
    { id       = { type = 30008 id = 109 }
      name     = "116ʦ "
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 284 }
      name     = "196'ޱ˵޷'ʦ "
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 285 }
      name     = "206ʦ "
      strength = 100
      type     = infantry
    }
  }
  # ############################
  # #############################
  landunit =
  { id       = { type = 30008 id = 110 }
    name     = "9ž "
    location = 247
    division =
    { id       = { type = 30008 id = 111 }
      name     = "156ʦ "
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 286 }
      name     = "106ʦ "
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 287 }
      name     = "47ʦ "
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 112 }
      name     = "32ʦ "
      strength = 30
      type     = cavalry
    }
  }
  # ##########################
  # ##########################
  landunit =
  { id       = { type = 30008 id = 113 }
    name     = "9ž "
    location = 243
    division =
    { id       = { type = 30008 id = 114 }
      name     = "176ʦ "
      strength = 80
      type     = infantry
    }
    division =
    { id            = { type = 30008 id = 288 }
      name          = "25ʦ "
      strength      = 80
      type          = infantry
      extra         = artillery
      brigade_model = 2
    }
    division =
    { id       = { type = 30008 id = 115 }
      name     = "74ʦ "
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 289 }
      name     = "51ʦ "
      strength = 80
      type     = infantry
      extra    = anti_air
    }
    division =
    { id       = { type = 30008 id = 116 }
      name     = "95'Ħά'ʦ "
      strength = 80
      type     = bergsjaeger
      extra    = engineer
    }
    division =
    { id       = { type = 30008 id = 117 }
      name     = "9'ķ˹'ʦ "
      strength = 80
      type     = cavalry
    }
    division =
    { id       = { type = 30008 id = 120 }
      name     = "15/218Ħлʦ "
      strength = 80
      type     = motorized
      extra    = anti_tank
    }
  }
  # #############################
  # ##############################
  landunit =
  { id       = { type = 30008 id = 121 }
    name     = "߼ "
    location = 1907
    division =
    { id       = { type = 30008 id = 122 }
      name     = "4'˹Ħ˹'ʦ "
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 290 }
      name     = "31ʦ "
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 291 }
      name     = "136ʦ "
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 123 }
      name     = "138ʦ "
      strength = 80
      type     = bergsjaeger
    }
    division =
    { id       = { type = 30008 id = 292 }
      name     = "47ʦ "
      strength = 80
      type     = bergsjaeger
    }
    division =
    { id       = { type = 30008 id = 124 }
      name     = "17'Ʒ'ɽزʦ"
      strength = 100
      type     = bergsjaeger
    }
    division =
    { id       = { type = 30008 id = 125 }
      name     = "63/76/77ʦ "
      strength = 100
      type     = bergsjaeger
    }
    division =
    { id       = { type = 30008 id = 126 }
      name     = "24ʦ "
      strength = 30
      type     = cavalry
    }
  }
  # ############################
  # ############################
  landunit =
  { id       = { type = 30008 id = 127 }
    name     = "ڶʮ˻еž "
    location = 277
    division =
    { id       = { type = 30008 id = 128 }
      name     = "6̹/236Ħлʦ "
      strength = 90
      type     = light_armor
      model    = 1
    }
  }
  # ###############################
  # ###############################
  landunit =
  { id       = { type = 30008 id = 130 }
    name     = "˹˾ "
    location = 153
    division =
    { id            = { type = 30008 id = 131 }
      name          = "88ʦ "
      strength      = 80
      type          = infantry
      extra         = artillery
      brigade_model = 2
    }
    division =
    { id       = { type = 30008 id = 293 }
      name     = "111ʦ "
      strength = 80
      type     = infantry
    }
  }
  # ##################################
  # ##################################
  landunit =
  { id       = { type = 30008 id = 132 }
    name     = "Ī˹ƾ "
    location = 175
    division =
    { id       = { type = 30008 id = 133 }
      name     = "118ʦ "
      strength = 80
      type     = infantry
      extra    = engineer
    }
    division =
    { id       = { type = 30008 id = 294 }
      name     = "235ʦ "
      strength = 80
      type     = infantry
      extra    = engineer
    }
  }
  # #################################
  # #################################
  landunit =
  { id       = { type = 30008 id = 134 }
    name     = "߼ "
    location = 1845
    division =
    { id            = { type = 30008 id = 135 }
      name          = "175ʦ "
      strength      = 100
      type          = infantry
      extra         = artillery
      brigade_model = 2
    }
    division =
    { id       = { type = 30008 id = 295 }
      name     = "165ʦ "
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 296 }
      name     = "157ʦ "
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 136 }
      name     = "28ʦ "
      strength = 30
      type     = bergsjaeger
    }
    division =
    { id       = { type = 30008 id = 138 }
      name     = "203/220Ħлʦ "
      strength = 60
      type     = motorized
      extra    = anti_tank
    }
  }
  # #############################
  # #############################
  landunit =
  { id       = { type = 30008 id = 139 }
    name     = "ζ "
    location = 285
    division =
    { id            = { type = 30008 id = 140 }
      name          = "19''ʦ "
      strength      = 100
      type          = infantry
      extra         = artillery
      brigade_model = 2
    }
    division =
    { id       = { type = 30008 id = 297 }
      name     = "89ʦ "
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 298 }
      name     = "217ʦ "
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 141 }
      name     = "120ʦ "
      strength = 100
      type     = infantry
      extra    = anti_air
    }
    division =
    { id       = { type = 30008 id = 299 }
      name     = "145ʦ "
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 143 }
      name     = "222ʦ "
      strength = 70
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 300 }
      name     = "149ʦ "
      strength = 70
      type     = infantry
    }
  }
  # ##############################
  # #############################
  landunit =
  { id       = { type = 30008 id = 144 }
    name     = "Ǿ "
    location = 1556
    division =
    { id       = { type = 30008 id = 145 }
      name     = "68/83/194ʦ "
      strength = 100
      type     = bergsjaeger
    }
    division =
    { id       = { type = 30008 id = 146 }
      name     = "21'˶ķ'ɽزʦ "
      strength = 100
      type     = bergsjaeger
    }
    division =
    { id       = { type = 30008 id = 148 }
      name     = "221Ħл/238ʦ "
      strength = 80
      type     = motorized
      extra    = anti_air
    }
  }
  # ###########################
  # ############################
  landunit =
  { id       = { type = 30008 id = 149 }
    name     = "ⱴӶ "
    location = 1520
    division =
    { id       = { type = 30008 id = 150 }
      name     = "65ʦ "
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 301 }
      name     = "114ʦ "
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 151 }
      name     = "93''ʦ "
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 302 }
      name     = "94ʦ "
      strength = 80
      type     = infantry
    }
  }
  # ##############################
  # ##############################
  landunit =
  { id       = { type = 30008 id = 152 }
    name     = "17ž "
    location = 1370
    division =
    { id       = { type = 30008 id = 154 }
      name     = "36/57/82Ħлʦ "
      strength = 100
      type     = motorized
      extra    = anti_tank
    }
  }
  # ##############################
  # ##############################
  landunit =
  { id       = { type = 30008 id = 155 }
    name     = "1ž "
    location = 1523
    division =
    { id       = { type = 30008 id = 156 }
      name     = "39ʦ "
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 303 }
      name     = "26'˹з'ʦ "
      strength = 100
      type     = infantry
    }
    division =
    { id            = { type = 30008 id = 304 }
      name          = "21'˶ķ'ʦ "
      strength      = 100
      type          = infantry
      extra         = artillery
      brigade_model = 2
    }
    division =
    { id            = { type = 30008 id = 157 }
      name          = "59ʦ "
      strength      = 80
      type          = infantry
      extra         = artillery
      brigade_model = 2
    }
    division =
    { id       = { type = 30008 id = 305 }
      name     = "22'˹ŵ'ʦ "
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 158 }
      name     = "1ʦ "
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 306 }
      name     = "4'˹Ħ˹'ʦ "
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 307 }
      name     = "5'άݲ˹'ʦ "
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 160 }
      name     = "239Ħлʦ "
      strength = 30
      type     = motorized
      extra    = anti_tank
    }
  }
  # #########################
  # ##########################
  landunit =
  { id       = { type = 30008 id = 161 }
    name     = "Զرž "
    location = 1526
    division =
    { id       = { type = 30008 id = 162 }
      name     = "79ʦ "
      strength = 80
      type     = infantry
      extra    = engineer
    }
    division =
    { id       = { type = 30008 id = 308 }
      name     = "78ʦ "
      strength = 80
      type     = infantry
      extra    = engineer
    }
    division =
    { id       = { type = 30008 id = 163 }
      name     = "35''ʦ "
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 309 }
      name     = "66ʦ "
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 164 }
      name     = "101ʦ "
      strength = 30
      type     = bergsjaeger
    }
  }
  # ###########################
  # ###########################
  landunit =
  { id       = { type = 30008 id = 165 }
    name     = "2ž "
    location = 1827
    division =
    { id            = { type = 30008 id = 166 }
      name          = "12ʦ "
      strength      = 80
      type          = infantry
      extra         = artillery
      brigade_model = 2
    }
    division =
    { id            = { type = 30008 id = 310 }
      name          = "3'ٻ˶'ʦ "
      strength      = 80
      type          = infantry
      extra         = artillery
      brigade_model = 2
    }
  }
  # #############################
  # #############################
  landunit =
  { id       = { type = 30008 id = 168 }
    name     = "25ž "
    location = 1570
    division =
    { id            = { type = 30008 id = 169 }
      name          = "92ʦ "
      strength      = 80
      type          = infantry
      extra         = artillery
      brigade_model = 2
    }
    division =
    { id       = { type = 30008 id = 311 }
      name     = "32'з'ʦ "
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 30008 id = 170 }
      name     = "40'Ų'ʦ "
      strength = 80
      type     = infantry
      extra    = anti_air
    }
    division =
    { id       = { type = 30008 id = 312 }
      name     = "105ʦ "
      strength = 80
      type     = infantry
    }
  }
  navalunit =
  { id       = { type = 10848 id = 5113 }
    name     = " "
    location = 133 # Murmansk
    base     = 133
    division =
    { id    = { type = 10849 id = 200 }
      name  = "1֧ "
      type  = destroyer
      model = 0
    }
    division =
    { id    = { type = 10849 id = 201 }
      name  = "2֧ "
      type  = destroyer
      model = 0
    }
    division =
    { id    = { type = 10849 id = 202 }
      name  = "1Ǳ֧ͧ "
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 10849 id = 203 }
      name  = "2Ǳ֧ͧ "
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 10849 id = 998 }
      name  = "30Ǳ֧ͧ "
      type  = submarine
      model = 2
    }
    division =
    { id    = { type = 10849 id = 997 }
      name  = "31Ǳ֧ͧ "
      type  = submarine
      model = 2
    }
  }
  navalunit =
  { id       = { type = 10848 id = 5114 }
    name     = "첨޵ĺ "
    location = 187 # Leningrad
    base     = 187
    division =
    { id    = { type = 10849 id = 204 }
      name  = " "
      type  = battleship
      model = 0
    }
    division =
    { id    = { type = 10849 id = 205 }
      name  = "ʮ¸ "
      type  = battleship
      model = 0
    }
    division =
    { id    = { type = 10849 id = 500 }
      name  = " "
      type  = heavy_cruiser
      model = 1
    }
    division =
    { id    = { type = 10849 id = 206 }
      name  = "3֧ "
      type  = destroyer
      model = 0
    }
    division =
    { id    = { type = 10849 id = 207 }
      name  = "4֧ "
      type  = destroyer
      model = 1
    }
    division =
    { id    = { type = 10849 id = 208 }
      name  = "3Ǳ֧ͧ "
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 10849 id = 209 }
      name  = "4Ǳ֧ͧ "
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 10849 id = 210 }
      name  = "5Ǳ֧ͧ "
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 10849 id = 211 }
      name  = "6Ǳ֧ͧ "
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 10849 id = 212 }
      name  = "7Ǳ֧ͧ "
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 10849 id = 996 }
      name  = "32Ǳ֧ͧ "
      type  = submarine
      model = 2
    }
    division =
    { id    = { type = 10849 id = 995 }
      name  = "33Ǳ֧ͧ "
      type  = submarine
      model = 2
    }
  }
  navalunit =
  { id       = { type = 10848 id = 5115 }
    name     = "ں "
    location = 253 # Sevastopol
    base     = 253
    division =
    { id    = { type = 10849 id = 234 }
      name  = "蹫 "
      type  = battleship
      model = 0
    }
    division =
    { id    = { type = 10849 id = 214 }
      name  = "ɫ "
      type  = light_cruiser
      model = 0
    }
    division =
    { id    = { type = 10849 id = 215 }
      name  = "ī "
      type  = light_cruiser
      model = 0
    }
    division =
    { id    = { type = 10849 id = 216 }
      name  = "ɫڿ "
      type  = light_cruiser
      model = 0
    }
    division =
    { id    = { type = 10849 id = 217 }
      name  = "ɫ߼ "
      type  = heavy_cruiser
      model = 0
    }
    division =
    { id    = { type = 10849 id = 218 }
      name  = "5֧ "
      type  = destroyer
      model = 1
    }
    division =
    { id    = { type = 10849 id = 219 }
      name  = "6֧ "
      type  = destroyer
      model = 1
    }
    division =
    { id    = { type = 10849 id = 220 }
      name  = "8Ǳ֧ͧ "
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 10849 id = 221 }
      name  = "9Ǳ֧ͧ "
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 10849 id = 222 }
      name  = "10Ǳ֧ͧ "
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 10849 id = 223 }
      name  = "11Ǳ֧ͧ "
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 10849 id = 994 }
      name  = "34Ǳ֧ͧ "
      type  = submarine
      model = 2
    }
    division =
    { id    = { type = 10849 id = 993 }
      name  = "35Ǳ֧ͧ "
      type  = submarine
      model = 2
    }
  }
  navalunit =
  { id       = { type = 10848 id = 5116 }
    name     = "̫ƽ󽢶 "
    location = 1372 # Vladivostok
    base     = 1372
    division =
    { id    = { type = 10849 id = 600 }
      name  = "18Ǳ֧ͧ "
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 10849 id = 601 }
      name  = "19Ǳ֧ͧ "
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 10849 id = 602 }
      name  = "20Ǳ֧ͧ "
      type  = submarine
      model = 0
    }
    division =
    { id    = { type = 10849 id = 603 }
      name  = "21Ǳ֧ͧ "
      type  = submarine
      model = 0
    }
    division =
    { id    = { type = 10849 id = 604 }
      name  = "22Ǳ֧ͧ "
      type  = submarine
      model = 0
    }
    division =
    { id    = { type = 10849 id = 605 }
      name  = "23Ǳ֧ͧ "
      type  = submarine
      model = 0
    }
    division =
    { id    = { type = 10849 id = 606 }
      name  = "24Ǳ֧ͧ "
      type  = submarine
      model = 0
    }
    division =
    { id    = { type = 10849 id = 607 }
      name  = "25Ǳ֧ͧ "
      type  = submarine
      model = 0
    }
    division =
    { id    = { type = 10849 id = 608 }
      name  = "26Ǳ֧ͧ "
      type  = submarine
      model = 0
    }
    division =
    { id    = { type = 10849 id = 609 }
      name  = "27Ǳ֧ͧ "
      type  = submarine
      model = 0
    }
    division =
    { id    = { type = 10849 id = 224 }
      name  = "7֧ "
      type  = destroyer
      model = 1
    }
    division =
    { id    = { type = 10849 id = 225 }
      name  = "8֧ "
      type  = destroyer
      model = 2
    }
    division =
    { id    = { type = 10849 id = 999 }
      name  = "9֧ "
      type  = destroyer
      model = 2
    }
    division =
    { id    = { type = 10849 id = 226 }
      name  = "12Ǳ֧ͧ "
      type  = submarine
      model = 0
    }
    division =
    { id    = { type = 10849 id = 227 }
      name  = "13Ǳ֧ͧ "
      type  = submarine
      model = 0
    }
    division =
    { id    = { type = 10849 id = 228 }
      name  = "14Ǳ֧ͧ "
      type  = submarine
      model = 0
    }
    division =
    { id    = { type = 10849 id = 229 }
      name  = "15Ǳ֧ͧ "
      type  = submarine
      model = 0
    }
    division =
    { id    = { type = 10849 id = 230 }
      name  = "16Ǳ֧ͧ "
      type  = submarine
      model = 0
    }
    division =
    { id    = { type = 10849 id = 231 }
      name  = "17Ǳ֧ͧ "
      type  = submarine
      model = 0
    }
    division =
    { id   = { type = 10849 id = 232 }
      name = "1佢֧ "
      type = transport
    }
  }
  # ##############################
  # ##############################
  airunit =
  { id       = { type = 30008 id = 171 }
    name     = "տվȺ "
    location = 187
    base     = 187
    division =
    { id       = { type = 30008 id = 172 }
      name     = "3/54߻ʦ "
      strength = 100
      type     = interceptor
      model    = 1
    }
    division =
    { id       = { type = 30008 id = 174 }
      name     = "41ըʦ "
      strength = 50
      type     = tactical_bomber
      model    = 0
    }
    division =
    { id       = { type = 30008 id = 175 }
      name     = "55߻ʦ "
      strength = 100
      type     = interceptor
      model    = 1
    }
    division =
    { id       = { type = 30008 id = 176 }
      name     = "1/2߻ʦ "
      strength = 100
      type     = interceptor
      model    = 1
    }
    division =
    { id       = { type = 30008 id = 177 }
      name     = "5߻ʦ "
      strength = 50
      type     = interceptor
      model    = 1
    }
  }
  # ##########################
  # ##########################
  airunit =
  { id       = { type = 30008 id = 178 }
    name     = "ӿվ˾ "
    location = 201
    base     = 201
    division =
    { id       = { type = 30008 id = 179 }
      name     = "21/57߻ʦ "
      strength = 100
      type     = interceptor
      model    = 1
    }
    division =
    { id       = { type = 30008 id = 180 }
      name     = "4/6߻ʦ "
      strength = 100
      type     = interceptor
      model    = 1
    }
    division =
    { id       = { type = 30008 id = 181 }
      name     = "8߻ʦ "
      strength = 50
      type     = interceptor
      model    = 1
    }
  }
  # #########################
  # ##########################
  airunit =
  { id       = { type = 30008 id = 182 }
    name     = "վ˾ "
    location = 282
    base     = 282
    division =
    { id       = { type = 30008 id = 183 }
      name     = "11/184߻ʦ "
      strength = 100
      type     = interceptor
      model    = 1
    }
    division =
    { id       = { type = 30008 id = 184 }
      name     = "12/13ըʦ "
      strength = 100
      type     = tactical_bomber
      model    = 0
    }
    division =
    { id       = { type = 30008 id = 185 }
      name     = "9/10߻ʦ "
      strength = 100
      type     = interceptor
      model    = 1
    }
  }
  # ##############################
  # ##############################
  airunit =
  { id       = { type = 30008 id = 186 }
    name     = "վ˾ "
    location = 238
    base     = 238
    division =
    { id       = { type = 30008 id = 187 }
      name     = "36/44߻ʦ "
      strength = 100
      type     = interceptor
      model    = 1
    }
    division =
    { id       = { type = 30008 id = 188 }
      name     = "63/64߻ʦ "
      strength = 100
      type     = interceptor
      model    = 1
    }
    division =
    { id       = { type = 30008 id = 189 }
      name     = "19/62ըʦ "
      strength = 100
      type     = tactical_bomber
      model    = 0
    }
    division =
    { id       = { type = 30008 id = 190 }
      name     = "14/15߻ʦ "
      strength = 100
      type     = interceptor
      model    = 1
    }
    division =
    { id       = { type = 30008 id = 191 }
      name     = "17߻ʦ "
      strength = 50
      type     = interceptor
      model    = 1
    }
  }
  # ##############################
  # ##############################
  airunit =
  { id       = { type = 30008 id = 192 }
    name     = "վ˾ "
    location = 233
    base     = 233
    division =
    { id       = { type = 30008 id = 193 }
      name     = "20/21߻ʦ "
      strength = 100
      type     = interceptor
      model    = 1
    }
    division =
    { id       = { type = 30008 id = 194 }
      name     = "45߻ʦ "
      strength = 50
      type     = interceptor
      model    = 1
    }
  }
  # ##############################
  # ###############################
  airunit =
  { id       = { type = 30008 id = 195 }
    name     = "߼վ˾ "
    location = 1848
    base     = 1848
    division =
    { id       = { type = 30008 id = 196 }
      name     = "25/27߻ʦ "
      strength = 100
      type     = interceptor
      model    = 0
    }
    division =
    { id       = { type = 30008 id = 197 }
      name     = "68/71߻ʦ "
      strength = 100
      type     = interceptor
      model    = 0
    }
    division =
    { id       = { type = 30008 id = 198 }
      name     = "26ըʦ "
      strength = 50
      type     = tactical_bomber
      model    = 0
    }
    division =
    { id       = { type = 30008 id = 199 }
      name     = "72߻ʦ "
      strength = 50
      type     = interceptor
      model    = 0
    }
  }
  # ################################
  # ################################
  airunit =
  { id       = { type = 30008 id = 200 }
    name     = "Ʒվ˾ "
    location = 248
    base     = 248
    division =
    { id       = { type = 30008 id = 201 }
      name     = "75/76߻ʦ "
      strength = 100
      type     = interceptor
      model    = 1
    }
    division =
    { id       = { type = 30008 id = 202 }
      name     = "49ըʦ "
      strength = 50
      type     = tactical_bomber
      model    = 0
    }
  }
  # ################################
  # #################################
  airunit =
  { id       = { type = 30008 id = 203 }
    name     = "Ī˹ƿվ˾ "
    location = 175
    base     = 175
    division =
    { id       = { type = 30008 id = 204 }
      name     = "6/78߻ʦ "
      strength = 100
      type     = interceptor
      model    = 0
    }
    division =
    { id       = { type = 30008 id = 205 }
      name     = "23/24߻ʦ "
      strength = 100
      type     = interceptor
      model    = 0
    }
    division =
    { id       = { type = 30008 id = 206 }
      name     = "46/47߻ʦ "
      strength = 100
      type     = interceptor
      model    = 0
    }
  }
  # ##############################
  # ##############################
  airunit =
  { id       = { type = 30008 id = 207 }
    name     = "߼վ˾ "
    location = 1848
    base     = 1848
    division =
    { id       = { type = 30008 id = 208 }
      name     = "73߻ʦ"
      strength = 50
      type     = interceptor
      model    = 0
    }
    division =
    { id       = { type = 30008 id = 209 }
      name     = "74ըʦ "
      strength = 50
      type     = tactical_bomber
      model    = 0
    }
  }
  # #############################
  # ##############################
  airunit =
  { id       = { type = 30008 id = 210 }
    name     = "ζվ˾ "
    location = 282
    base     = 282
    division =
    { id       = { type = 30008 id = 211 }
      name     = "75߻ʦ "
      strength = 50
      type     = interceptor
      model    = 1
    }
    division =
    { id       = { type = 30008 id = 212 }
      name     = "76ըʦ "
      strength = 50
      type     = tactical_bomber
      model    = 0
    }
  }
  # ###########################
  # ###########################
  airunit =
  { id       = { type = 30008 id = 213 }
    name     = "ⱴӶվ˾ "
    location = 1523
    base     = 1523
    division =
    { id       = { type = 30008 id = 214 }
      name     = "37/38߻ʦ "
      strength = 100
      type     = interceptor
      model    = 0
    }
    division =
    { id       = { type = 30008 id = 215 }
      name     = "30ըʦ "
      strength = 50
      type     = tactical_bomber
      model    = 0
    }
    division =
    { id       = { type = 30008 id = 216 }
      name     = "28߻ʦ "
      strength = 50
      type     = interceptor
      model    = 0
    }
  }
  # ##########################
  # ############################
  airunit =
  { id       = { type = 30008 id = 217 }
    name     = "Զվ˾ "
    location = 1372
    base     = 1372
    division =
    { id       = { type = 30008 id = 218 }
      name     = "29/31߻ʦ "
      strength = 100
      type     = interceptor
      model    = 0
    }
    division =
    { id       = { type = 30008 id = 219 }
      name     = "32/34߻ʦ "
      strength = 70
      type     = interceptor
      model    = 0
    }
    division =
    { id       = { type = 30008 id = 220 }
      name     = "69/79߻ʦ "
      strength = 100
      type     = interceptor
      model    = 0
    }
    division =
    { id       = { type = 30008 id = 221 }
      name     = "70߻ʦ "
      strength = 50
      type     = interceptor
      model    = 3
    }
    division =
    { id       = { type = 30008 id = 222 }
      name     = "33/53ըʦ "
      strength = 100
      type     = tactical_bomber
      model    = 1
    }
  }
  # ##########upgrading independent tank bgds to divs###############
  # ######SU had only 4 tank divs in 39 but lots of ind. tank bgds#########
  division_development =
  { id    = { type = 30008 id = 14 }
    name  = "21/24̹ʦ "
    type  = armor
    model = 1
    cost  = 3
    date  = { year = 1940 month = january }
  }
  division_development =
  { id    = { type = 30008 id = 19 }
    name  = "23/28̹ʦ "
    type  = armor
    model = 1
    cost  = 3
    date  = { year = 1940 month = january }
  }
  division_development =
  { id    = { type = 30008 id = 34 }
    name  = "27/36̹ʦ "
    type  = armor
    model = 1
    cost  = 3
    date  = { year = 1940 month = february }
  }
  division_development =
  { id    = { type = 30008 id = 37 }
    name  = "10/26̹ʦ "
    type  = armor
    model = 1
    cost  = 3
    date  = { year = 1940 month = february }
  }
  division_development =
  { id    = { type = 30008 id = 52 }
    name  = "29/33̹ʦ "
    type  = armor
    model = 1
    cost  = 3
    date  = { year = 1940 month = february }
  }
  division_development =
  { id    = { type = 30008 id = 56 }
    name  = "22/30̹ʦ "
    type  = armor
    model = 1
    cost  = 3
    date  = { year = 1940 month = march }
  }
  division_development =
  { id    = { type = 30008 id = 63 }
    name  = "25/31̹ʦ "
    type  = light_armor
    model = 1
    cost  = 3
    date  = { year = 1940 month = march }
  }
  division_development =
  { id    = { type = 30008 id = 77 }
    name  = "20/35̹ʦ "
    type  = light_armor
    model = 1
    cost  = 3
    date  = { year = 1940 month = march }
  }
  division_development =
  { id    = { type = 30008 id = 97 }
    name  = "8/32̹ʦ "
    type  = light_armor
    model = 1
    cost  = 3
    date  = { year = 1939 month = december }
  }
  division_development =
  { id    = { type = 30008 id = 102 }
    name  = "15/39̹ʦ "
    type  = light_armor
    model = 1
    cost  = 3
    date  = { year = 1940 month = february }
  }
  division_development =
  { id    = { type = 30008 id = 106 }
    name  = "12/34̹ʦ "
    type  = light_armor
    model = 1
    cost  = 3
    date  = { year = 1939 month = december }
  }
  division_development =
  { id    = { type = 30008 id = 118 }
    name  = "11/16̹ʦ "
    type  = light_armor
    model = 1
    cost  = 3
    date  = { year = 1940 month = january }
  }
  division_development =
  { id    = { type = 30008 id = 147 }
    name  = "9/19̹ʦ "
    type  = light_armor
    model = 1
    cost  = 3
    date  = { year = 1939 month = november }
  }
  division_development =
  { id    = { type = 30008 id = 320 }
    name  = "񲿶ӵ1ʦ "
    type  = infantry
    model = 1
    cost  = 0
    date  = { year = 1941 month = september }
  }
  division_development =
  { id    = { type = 30008 id = 321 }
    name  = "񲿶ӵ2ʦ "
    type  = infantry
    model = 1
    cost  = 0
    date  = { year = 1941 month = september }
  }
  division_development =
  { id    = { type = 30008 id = 322 }
    name  = "񲿶ӵ3ʦ "
    type  = infantry
    model = 1
    cost  = 0
    date  = { year = 1941 month = september }
  }
  division_development =
  { id    = { type = 30008 id = 323 }
    name  = "񲿶ӵ4ʦ "
    type  = infantry
    model = 1
    cost  = 0
    date  = { year = 1941 month = september }
  }
  division_development =
  { id    = { type = 30008 id = 324 }
    name  = "񲿶ӵ5ʦ "
    type  = infantry
    model = 1
    cost  = 0
    date  = { year = 1941 month = september }
  }
  division_development =
  { id    = { type = 30008 id = 325 }
    name  = "񲿶ӵ6ʦ "
    type  = infantry
    model = 1
    cost  = 0
    date  = { year = 1941 month = september }
  }
  division_development =
  { id    = { type = 30008 id = 326 }
    name  = "񲿶ӵ7ʦ "
    type  = infantry
    model = 1
    cost  = 0
    date  = { year = 1941 month = september }
  }
  division_development =
  { id    = { type = 30008 id = 327 }
    name  = "񲿶ӵ8ʦ "
    type  = infantry
    model = 1
    cost  = 0
    date  = { year = 1941 month = september }
  }
  division_development =
  { id    = { type = 30008 id = 328 }
    name  = "񲿶ӵ9ʦ "
    type  = infantry
    model = 1
    cost  = 0
    date  = { year = 1941 month = september }
  }
  division_development =
  { id    = { type = 30008 id = 329 }
    name  = "񲿶ӵ10ʦ "
    type  = infantry
    model = 1
    cost  = 0
    date  = { year = 1941 month = september }
  }
  division_development =
  { id    = { type = 30008 id = 330 }
    name  = "񲿶ӵ11ʦ "
    type  = infantry
    model = 1
    cost  = 0
    date  = { year = 1941 month = october }
  }
  division_development =
  { id    = { type = 30008 id = 331 }
    name  = "񲿶ӵ12ʦ "
    type  = infantry
    model = 1
    cost  = 0
    date  = { year = 1941 month = october }
  }
  division_development =
  { id    = { type = 30008 id = 332 }
    name  = "񲿶ӵ13ʦ "
    type  = infantry
    model = 1
    cost  = 0
    date  = { year = 1941 month = october }
  }
  division_development =
  { id    = { type = 30008 id = 333 }
    name  = "񲿶ӵ14ʦ "
    type  = infantry
    model = 1
    cost  = 0
    date  = { year = 1941 month = october }
  }
  # ships under construction
  division_development =
  { name  = "ϣԪ˧ "
    type  = heavy_cruiser
    model = 1
    cost  = 4.8
    id    = { type = 10849 id = 700 }
    date  = { year = 1940 month = june day = 15 }
  }
  division_development =
  { name  = "10֧ "
    type  = destroyer
    model = 1
    cost  = 1.9
    id    = { type = 10849 id = 701 }
    date  = { year = 1939 month = october day = 1 }
  }
  division_development =
  { name  = "36Ǳ֧ͧ "
    type  = submarine
    model = 1
    cost  = 1.9
    id    = { type = 10849 id = 702 }
    date  = { year = 1939 month = october day = 1 }
  }
  division_development =
  { name  = "37Ǳ֧ͧ "
    type  = submarine
    model = 2
    cost  = 1.9
    id    = { type = 10849 id = 703 }
    date  = { year = 1939 month = november day = 1 }
  }
}
